; ---------------------------------------------------------------------
; Name:             Neuer Ordner v0.1
; Author:           Wolfgang Reszel fr c't
; Datum:            5.12.2004
;
; Language:         german
; Platform:         tested with XP
; #Includeable:     yes
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Mit Strg+N wird im Explorer oder einem Dateidialog ein neuer
; Ordner angelegt
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; Strg+N erzeugt im Explorer oder Dateidialog einen neuen Ordner
~^N:: ; Strg+N (~ = native)
   WinGetClass, ActiveClass, A                    ; Klasse des aktiven Fensters
   If ActiveClass in ExploreWClass,CabinetWClass  ; Wenn Explorer-Fenster ...
   {
      ; Aktuellen Pfad anhand der Adressleiste ermitteln
      ControlGetText, MyCurrentExplorerDirectory, Edit1, ahk_class %ActiveClass%
      ; Neuen Ordner anlegen
      FileCreateDir, %MyCurrentExplorerDirectory%\Neuer Ordner
      ; Wenn kein Fehler
      if ErrorLevel = 0
      {
         ; 20 mal prfen, ob Ordner exisitert (dauert bei Netzlaufwerken etwas)
         Loop,20
         {
            IfExist, %MyCurrentExplorerDirectory%\Neuer Ordner   ; Prfen ob existiert
            {
               Send,{F5}                                         ; Explorer-Ansicht aktualisieren
               Send,Neuer Ordner{F2}                             ; Ordner auswhlen (durch Eingabe des Namens)
               break                                             ; Schleife verlassen
            }
            Sleep,100                                            ; kleine Pause
         }
      }
   }
   IfWinActive, ahk_class #32770                            ; Ist Dateidialog?
   {
      PostMessage, 0x111, 40962                                ; Direkten Befehl fr neuer Ordner senden
   }
return

